% plotPhotostability.m: Plots the photostability measurements of BiOI and Cs3Sb2I6Cl3
% Written 21/8/20 by Robert Hoye

clear;
clc;

% Universal constants
h = 6.62607004e-34;
c = 299792458;
q = 1.60217662e-19;

% Initalize arrays for collecting data
BiOI = zeros(2048,28);
CSI = zeros(2048,28);

% Load data
BiOI(:,1:2) = importdata('BiOI_0min.asc');
BiOI(:,3:4) = importdata('BiOI_1min.asc');
BiOI(:,5:6) = importdata('BiOI_2min.asc');
BiOI(:,7:8) = importdata('BiOI_3min.asc');
BiOI(:,9:10) = importdata('BiOI_4min.asc');
BiOI(:,11:12) = importdata('BiOI_5min.asc');
BiOI(:,13:14) = importdata('BiOI_6min.asc');
BiOI(:,15:16) = importdata('BiOI_7min.asc');
BiOI(:,17:18) = importdata('BiOI_8min.asc');
BiOI(:,19:20) = importdata('BiOI_9min.asc');
BiOI(:,21:22) = importdata('BiOI_10min.asc');
BiOI(:,23:24) = importdata('BiOI_21min.asc');
BiOI(:,25:26) = importdata('BiOI_25min.asc');
BiOI(:,27:28) = importdata('BiOI_30min.asc');

quartz_BiOI = importdata('quartz_BiOI.asc');
quartz_CSI = importdata('quartz_encap_CSI.asc');

CSI(:,1:2) = importdata('CSI_0min.asc');
CSI(:,3:4) = importdata('CSI_1min.asc');
CSI(:,5:6) = importdata('CSI_2min.asc');
CSI(:,7:8) = importdata('CSI_3min.asc');
CSI(:,9:10) = importdata('CSI_4min.asc');
CSI(:,11:12) = importdata('CSI_5min.asc');
CSI(:,13:14) = importdata('CSI_6min.asc');
CSI(:,15:16) = importdata('CSI_7min.asc');
CSI(:,17:18) = importdata('CSI_8min.asc');
CSI(:,19:20) = importdata('CSI_9min.asc');
CSI(:,21:22) = importdata('CSI_10min.asc');
CSI(:,23:24) = importdata('CSI_11min.asc');
CSI(:,25:26) = importdata('CSI_25min.asc');
CSI(:,27:28) = importdata('CSI_30min.asc');

% Extract the wavelength of the peak PL
time_BiOI = [0 1 2 3 4 5 6 7 8 9 10 21 25 30];
time_CSI = [0 1 2 3 4 5 6 7 8 9 10 11 25 30];

wavelengths_BiOI = zeros(14,1);
wavelengths_CSI = zeros(14,1);

for i = 1:14
    
    [M,I] = max(BiOI(:,2*i));
    
    wavelengths_BiOI(i) = BiOI(I,2*i-1);
    
end;

for j = 1:14
    
    [M,I] = max(CSI(:,2*j));
    
    wavelengths_CSI(j) = CSI(I,2*j-1);
    
end;

% Calculate energies
hv_BiOI = h.*c./(wavelengths_BiOI.*1e-9)./q; % eV
hv_CSI = h.*c./(wavelengths_CSI.*1e-9)./q; % eV

% Plot PL at time zero
f1 = figure;
f2 = figure;

widthLine = 3;

h1 = figure(f1);
plot(h.*c./(quartz_BiOI(:,1).*1e-9)./q, quartz_BiOI(:,2), 'LineWidth', widthLine, 'Color', [77 187 213]./256);
hold on;

figure(f1);
plot(h.*c./(BiOI(:,1).*1e-9)./q, BiOI(:,2), 'LineWidth', widthLine, 'Color', [55 173 107]./256);
xlabel('h\nu (eV)'), ylabel('PL (cps)');
axis([1.4 2.5 0 20e4]);
legend({'Quartz', 'BiOI/NiO_x/quartz'}, 'Box', 'off', 'location', 'northwest');
set(gca, 'FontSize', 25, 'XMinorTick', 'on', 'YMinorTick', 'on');
set(h1, 'pos', [100 100 400 350]);

hold off;

h2 = figure(f2);
plot(h.*c./(quartz_CSI(:,1).*1e-9)./q, quartz_CSI(:,2), 'LineWidth', widthLine, 'Color', [77 187 213]./256);
hold on;

figure(f2);
plot(h.*c./(CSI(:,1).*1e-9)./q, CSI(:,2), 'LineWidth', widthLine, 'Color', [251 101 1]./256);
xlabel('h\nu (eV)'), ylabel('PL (cps)');
axis([1.4 2.5 0 5e4]);
legend({'Quartz', 'Cs_3Sb_2(I,Cl)_9/quartz'}, 'Box', 'off', 'location', 'northeast');
set(gca, 'FontSize', 25, 'XMinorTick', 'on', 'YMinorTick', 'on');
set(h2, 'pos', [100 100 400 350]);

hold off;

% Plot PL against time
f3 = figure;

markerSize = 10;

h3 = figure(f3);
plot(time_CSI, hv_CSI, 'o', 'MarkerSize', markerSize, 'MarkerFaceColor', [251 101 1]./256, 'MarkerEdgeColor', [251 101 1]./256);
hold on;

figure(f3);
plot(time_BiOI, hv_BiOI, 's', 'MarkerSize', markerSize, 'MarkerFaceColor', [55 173 107]./256, 'MarkerEdgeColor', [55 173 107]./256);
xlabel('Time (min)'), ylabel('Energy of PL peak (eV)');
axis([0 30 1.1 2.5]);
legend({'Cs_3Sb_2(I,Cl)_9', 'BiOI'}, 'Box', 'off', 'location', 'northeast');
set(gca, 'FontSize', 25, 'XMinorTick', 'on', 'YMinorTick', 'on');
set(h3, 'pos', [100 100 400 350]);

% Calculate the average PL wavelength and the uncertainty
hv_avg_BiOI = mean(hv_BiOI);
hv_avg_CSI = mean(hv_CSI);

dhv_BiOI = 2.*std(hv_BiOI)/sqrt(14);
dhv_CSI = 2.*std(hv_CSI)/sqrt(14);


